# SALT

"offering atomicity and isolation at the same granularity is the very reason why ACID
transactions are ill-equipped .....(performance vs programmability)"

**Pareto Principle:** 80% of effects from 20% of causes

-splitting ACID transactions up very good for concurrency
 - bad for isolation
- key issue is to provide isolation at a finer granularity, same atomicity
  - nested transactions give subtrans' atomicity, isolate entire thing

## Background

ANSI iso levels:
- read-uncommitted
- read-committed (assumed goal for paper)
- repeatable read
- serializable

Issues:
- dirty writes: overwrite uncomitted
- dirty reads: read from uncommitted
- non-repeatable reads
- phantom

## BASE transactions
  - **alkaline** subtransactions
    - no other transactions can see state of *uncommitted alkaline subtrans*
    - **committed** alk subtrans state viewable by other BASE or alkaline transactions
    - *not visible* until entire BASE commit.
  - **salt isolation** allows control of internal states visibility (among other BASE transactions)
  - each alkaline sub has associated *exception*
  - *BASE transactions look like ACID transactions to other ACID transactions*
  - **accepted** once any alkaline trans commits,
    - accepted implies commit of entire BASE
    - i.e. all operations successfully executed *or bypassed because of some exception*
  - aborted only if they encounter an error before the transaction is accepted (unlike ACID)

## Isolation

*"If two operations in different transactions conflict, then the temporal dependency
    that exists between the earlier and the later of these operations  must extend to the
    entire transaction"* (allows SALT to work w/ different isolation levels)

*Isolation:* Let Q be the set of operation types {read, range-read, write} and let L and S
be subsets of Q . Further, let o1 in txn1 and o2 in txn2, be two operations, respectively
of type T1 ∈ L and T2 ∈ S , that access the same object in a conflicting
(i.e. non read-read) manner. **If o1 completes before o2 starts, then txn1 must decide
before o2 starts.**

Isolation property holds if at least one is ACID, or both are alkaline.


![sets](saltSets.png)


## Salt Isolation
**Salt Isolation**: 
The Isolation property holds as long as (a) at least one of txn<sub>1</sub> and
txn<sub>2</sub> is an ACID transaction or (b) both txn<sub>1</sub> and txn<sub>2</sub> are alkaline
subtransactions.  

So:
- ACID transactions isolated from all other
- Alkaline subtrans isolated from ACID and other alkaline
- BASE expose states at alkaline boundaries to other BASE


- Design
  - locks (because high contention)
    - type
      - ACID - conflict with alkaline and saline
      - alkaline - conflict w/ ACID and other alkaline
      - saline: conflict with ACID locks (except for read/read) only
    - lock duration
      - *long term* (life of trans, 2PL) 
      - *short-term* (just the op)
    - acquire only an alkaline lock at operation start
      - “downgrade” it to saline at end of subtransaction, hold until after the end of the BASE transaction. 
  - no multi-version concurrency

![sets](saltConcurrent.png)

## Indirect Dirty Reads
<p>

![fig4](saltFig4.png)
<p>
Fixed by:

- **Read-after-write across transactions** A BASE transaction B<sub>r</sub> that reads a value x, which has been written by another BASE<sub>w</sub> transaction, cannot release its saline lock on x until B<sub>w</sub> has released its own saline lock on x. 

- **Write-after-read within a transaction** An operation O<sub>w</sub> that writes a value x cannot
  release its saline lock on x until all previous read operations within the **same** BASE
  transaction have released their saline locks on their respective objects.

These two ensure uncommitted writes keep locks until all prior read locks also released.

<p>

## Forward Logging
- after BASE knows it will commit (because a subsaline committed), log entire BASE
- prevents cascades that would have occurred because of saline visibility

### Banking, again

![fig1](saltAcidApp.png)
![banking](saltBanking.png)

## Performance

![saltPerf1](saltPerf1.png)

![saltPerf2](saltPerf2.png)


## Comments

- Kaitlyn - How easy to find the performance-critical transactions? Complicated, better ways to do it?
- Dhanvee - Really worth it to start w/ Base adn ACID-ifying?


