//
package main

/*

 */

import (
	"fmt"
	. "github.com/mattn/go-getopt"
	"os"
	"runtime"

	"p2/dfs"
)

//=============================================================================

func main() {
	var c int
	tm := ""
	debug := false
	newfs := false
	readOnly := false
	mount := "dss"
	chunkPath := "chunks"

	for {
		if c = Getopt("c:dm:nrt:"); c == EOF {
			break
		}

		switch c {
		case 'c':
			chunkPath = OptArg
		case 'd':
			debug = !debug
		case 'm':
			mount = OptArg
		case 'n':
			newfs = !newfs
		case 'r':
			readOnly = !readOnly
		case 't':
			tm = OptArg
		default:
			println("usage: main.go [-d | -c | -m <mountpt> | -t <timespec>]", c)
			os.Exit(1)
		}
	}
	fmt.Printf("\nStartup up with debug %v, newfs %v, mountpt: %q, chunkpath %q, time %q, mprocs %v\n\n",
		debug, newfs, mount, chunkPath, tm)

	dfs.Init(debug, newfs, mount, chunkPath, tm, readOnly)

}
