package main

import (
	"github.com/golang/protobuf/proto"
	. "github.com/mattn/go-getopt"
	"math/rand"
	. "tango/library"
	. "tango/pb"
	"time"
)

type Register struct {
	oid   uint64
	state uint64
}

func (r *Register) Apply(data []byte) {
	val := &SetUint64Value{}
	proto.Unmarshal(data, val)
	r.state = val.Value
	Pout("applied, now: %v\n", r.state)
}

func (r *Register) writeRegister(newstate uint64) {
	val := &SetUint64Value{}
	val.Value = newstate
	bytes, _ := proto.Marshal(val)
	UpdateHelper(bytes, Entry_REGISTER, r.oid)
	Pout("update helper to %v, now %v\n", newstate, r.state)
}

func (r *Register) readRegister() uint64 {
	Pout("read before: %v\n", r.state)
	QueryHelper(r.oid, r)
	Pout("read after: %v\n", r.state)
	return r.state
}

var _ TangoObject = (*Register)(nil)

func main() {
	var c int

	for {
		if c = Getopt("dp:"); c == EOF {
			break
		}

		switch c {
		case 'd':
			Debug = !Debug
		}
	}

	rand.Seed(time.Now().UnixNano())
	reg := Register{oid: uint64(rand.Intn(1000)), state: 0}

	reg.writeRegister(42)
	reg.writeRegister(43)
	reg.writeRegister(44)
	Perr("%v\n", reg.state)

	reg.readRegister()
	Perr("%v\n", reg.state)

	reg.writeRegister(45)
	reg.readRegister()
	Perr("%v\n", reg.state)

}
