package main

import (
	. "github.com/mattn/go-getopt"
	"math/rand"
	. "tango/library"
	. "tango/pb"
	"time"
)

type StringSet struct {
	oid     uint64
	strings []string
}

func (o *StringSet) Apply(data []byte) {
	s := string(data)
	o.strings = append(o.strings, s)
	Pout("applied %q, now: %v\n", s, o.strings)
}

func (o *StringSet) AddString(s string) {
	UpdateHelper([]byte(s), Entry_STRINGSET, o.oid)
	Pout("add %q\n", s)
}

func (o *StringSet) ReadStrings() []string {
	QueryHelper(o.oid, o)
	Pout("strings = %v\n", o.strings)
	return o.strings
}

var _ TangoObject = (*StringSet)(nil)

func main() {
	var c int

	for {
		if c = Getopt("dp:"); c == EOF {
			break
		}

		switch c {
		case 'd':
			Debug = !Debug
		}
	}

	rand.Seed(time.Now().UnixNano())
	ss := StringSet{oid: uint64(rand.Intn(1000)), strings: []string{}}

	ss.AddString("one")
	ss.AddString("two")
	ss.AddString("three")

	strs := ss.ReadStrings()
	Perr("read strings: %v\n", strs)
}
