package library

import (
	"log"
	"os"
)

var Debug = false

//=====================================================================

type TangoObject interface {
	Apply(data []byte)
}

type TangoRuntime interface {
	UpdateHelper(newState *[]byte, oid uint64)
	QueryHelper(uint64)
}

type RegisterInterface interface {
	Write(uint64)
	Read() uint64
}

type StringSetInterface interface {
	AddString(string)
	ReadStrings() []string
}

type TreeNodeInterface interface {
	Left() TreeNodeInterface
	Right() TreeNodeInterface
	Label() string
	Print()
}

//=====================================================================
func Pout(s string, args ...interface{}) {
	if !Debug {
		return
	}
	log.Printf(s, args...)
}

func Pif(flag bool, s string, args ...interface{}) {
	if flag {
		log.Printf(s, args...)
	}
}

// if false print
func Pfalse(ok bool, s string, args ...interface{}) {
	if !ok {
		log.Printf(s, args...)
	}
}

func Perr(s string, args ...interface{}) {
	log.Printf(s, args...)
}

func Pinv(e error, s string) {
	if e != nil {
		log.Printf("Exiting because of error (%v): %s\n", e, s)
		os.Exit(1)
	}
}

func Passert(b bool, s string, args ...interface{}) {
	if !b {
		log.Printf(s, args...)
		os.Exit(1)
	}
}

func Pnilexit(e error, s string, args ...interface{}) {
	if e != nil {
		log.Printf(s, args...)
		os.Exit(1)
	}
}

func Pexit(s string, args ...interface{}) {
	log.Printf(s, args...)
	os.Exit(1)
}
