package main

import (
	. "github.com/mattn/go-getopt"
	"golang.org/x/net/context"
	"google.golang.org/grpc"
	"google.golang.org/grpc/reflection"
	"net"
	. "tango/library"
	. "tango/pb"
)

//=====================================================================

type TangoLog struct {
	entries  []Entry
	logIndex int
}

//var _ TangoRuntime = (*Client)(nil)

var tlog TangoLog

func (s *ServerType) Write(ctx context.Context, in *WriteRequest) (*WriteReply, error) {
	Pout("WRITE oid %v\n", in.Entry.Oid)
	tlog.entries = append(tlog.entries, *in.Entry)
	return &WriteReply{Ok: true}, nil
}

func (s *ServerType) Read(ctx context.Context, in *ReadRequest) (*ReadReply, error) {
	Pout("READ IDENT %v, read has %v, server has %v\n", in.Identity, in.Have, len(tlog.entries))
	pointers := []*Entry{}
	for i := in.Have; i < uint64(len(tlog.entries)); i++ {
		pointers = append(pointers, &tlog.entries[i])
	}
	return &ReadReply{Ok: true, Sent: uint64(len(tlog.entries)) - in.Have, Entries: pointers}, nil
}

type ServerType struct {
	UnimplementedTangoServer
}

func main() {
	var c int
	port := ":8111"

	for {
		if c = Getopt("dp:"); c == EOF {
			break
		}

		switch c {
		case 'd':
			Debug = !Debug
		case 'p':
			port = ":" + OptArg
		}
	}

	lis, err := net.Listen("tcp", port)
	if err != nil {
		Pexit("failed to listen: %v", err)
	}
	s := grpc.NewServer()
	RegisterTangoServer(s, &ServerType{})
	// Register reflection service on gRPC server.
	reflection.Register(s)
	if err := s.Serve(lis); err != nil {
		Pexit("failed to serve: %v", err)
	}
}

//=====================================================================
