package main

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
	"math/rand"
	"os"
	"os/signal"
	"strconv"
	"strings"
	"sync"
	"syscall"
	"time"

	"epaxos/pb"

	. "github.com/mattn/go-getopt"
	"golang.org/x/net/context"
	"google.golang.org/grpc"
)

//=====================================================================

func main() {
	hostname, _ = os.Hostname()

	for {
		if c := Getopt("a:o:pP:dc:C:n:N:s:t:r"); c == EOF {
			break
		} else {
			switch c {
			case 'o':
				// repID,r|w|p|d,key,value
				oneAccess = OptArg

			case 'd':
				debug = !debug

			case 'c':
				configFile = OptArg

			case 'N':
				N, _ = strconv.Atoi(OptArg)

			case 'p':
				time.Sleep(time.Duration(pauseInterval) * time.Second)

			}
		}
	}

	//=====================================================================

	// Compute the identity
	if hostname != "" {
		identity = fmt.Sprintf("%s-%04X-", hostname, rand.Intn(0x10000))
	} else {
		identity = fmt.Sprintf("%04X-%04X-", rand.Intn(0x10000), rand.Intn(0x10000))
	}

	//=====================================================================
	sigch := make(chan os.Signal, 1)
	signal.Notify(sigch, syscall.SIGTERM, os.Interrupt, os.Kill)
	go func() {
		<-sigch
		writeMetrics()
	}()

	//=====================================================================
	config := new(ConfigFile)
	if dat, err := ioutil.ReadFile(configFile); err == nil {
		if err := json.Unmarshal(dat, config); err != nil {
			p_exit("Unable to unmarshal config: %v\n", err)
		}
	} else {
		p_exit("Unable to open config file: %v\n", err)
	}

}

//=====================================================================

func p_out(s string, args ...interface{}) {
	if !debug {
		return
	}
	fmt.Printf(s, args...)
}

func p_err(s string, args ...interface{}) {
	fmt.Printf(s, args...)
}

func p_exit(s string, args ...interface{}) {
	fmt.Printf(s, args...)
	writeMetrics()
	os.Exit(1)
}

//=====================================================================

func min(a, b uint64) uint64 {
	if a < b {
		return a
	} else {
		return b
	}
}
