package main

import (
	"encoding/json"
	"fmt"
	"github.com/looplab/tarjan"
	. "github.com/mattn/go-getopt"
	"io"
	"io/ioutil"
	"net"
	"os"
	"os/signal"
	//"runtime"
	"sort"
	"strconv"
	"strings"
	"syscall"

	//"sync"
	"time"

	"epaxos/pb"
	"golang.org/x/net/context"
	"google.golang.org/grpc"
	"google.golang.org/grpc/reflection"
)

type ServerType struct {
	pb.UnimplementedReplicaServer
}

//=====================================================================

func main() {
	hostname, _ = os.Hostname()

	for {
		if c := Getopt("ad:er:N:opc:t"); c == EOF {
			break
		} else {
			switch c {
			case 'd':
				debug, _ = strconv.Atoi(OptArg)

			case 'N':
				N, _ = strconv.Atoi(OptArg)

			case 'p':
				commitPause = !commitPause

			case 'r':
				me, _ = strconv.Atoi(OptArg)

			case 't':
				thrifty = !thrifty

			case 'c':
				configFile = OptArg
			}
		}
	}
	//=====================================================================

	config := new(ConfigFile)
	if dat, err := ioutil.ReadFile(configFile); err == nil {
		if err := json.Unmarshal(dat, config); err != nil {
			p_exit("Unable to unmarshal config: %v\n", err)
		}
	} else {
		p_exit("Unable to open config file: %v\n", err)
	}
	if N == 0 {
		N = config.N
	}

}

//=====================================================================

func p_level(l int, s string, args ...interface{}) {
	if debug < l {
		return
	}
	//	fmt.Printf(strconv.Itoa(me)+":"+fmt.Sprintf("%v ", executed)+s, args...)
	fmt.Printf(strconv.Itoa(me)+":"+s, args...)
}

func p_out(s string, args ...interface{}) {
	p_level(9, s, args...)
}

func p_err(s string, args ...interface{}) {
	p_level(-1, s, args...)
}

func p_bare(s string, args ...interface{}) {
	fmt.Printf(s, args...)
}

func p_assert(pred bool, s string, args ...interface{}) {
	if !pred {
		p_exit(fmt.Sprintf(strconv.Itoa(me)+": "+s, args...))
	}
}

func p_exit(s string, args ...interface{}) {
	fmt.Printf(strconv.Itoa(me)+":"+s, args...)
	os.Exit(1)
}

func p_exitif(cond bool, s string, args ...interface{}) {
	if cond {
		p_exit(strconv.Itoa(me)+":"+s, args...)
	}
}
