//
package main

/*

 */

import (
	"fmt"
	. "github.com/mattn/go-getopt"
	"os"
	// "strconv"

	"p3/dfs"
)

//=============================================================================

func main() {
	var c int
	tm := ""
	debug := false
	newfs := false
	readOnly := false
	mount := "dss"
	chunkPath := "chunks"
	logPath := ""
	showChunks := false
	port := ":8000"

	for {
		if c = Getopt("c:Cdl:m:np:rs:t:"); c == EOF {
			break
		}

		switch c {
		case 'c':
			chunkPath = OptArg
		case 'C':
			showChunks = true
		case 'd':
			debug = !debug
		case 'l':
			logPath = OptArg
		case 'm':
			mount = OptArg
		case 'n':
			newfs = !newfs
		case 'p':
			port = ":" + OptArg
		case 'r':
			readOnly = !readOnly
		case 't':
			tm = OptArg
		default:
			println("usage: main.go [-d | -c | -l | -m <mountpt> | -t <timespec>]", c)
			os.Exit(1)
		}
	}
	fmt.Printf("\nStartup up with debug %v, newfs %v, mountpt: %q, chunkpath %q, logpath %q, time %q, port: %s\n\n",
		debug, newfs, mount, chunkPath, logPath, tm, port)

	dfs.Init(debug, newfs, mount, chunkPath, logPath, showChunks, tm, readOnly, port)

}
