# Application Crash Consistency and Performance with CCFS

**Basic idea**
- good crash behavior through consistent journaling
- fast by allowing many optimizations

File sytems want to:
- re-order writes
- delayed allocation
    - allows bulk allocation, cheaper and more efficient for data structure
- journal for correctness

File systems don't know about:
- true vs false dependencies

ext4 writes both meta and data to journal
  - journal is a log 
  - \<commit\>
  - then writes propagated to correct positions (*checkpointed*)
  - these writes can be re-ordered at will


Resulting in ordering constraints from one app enforced on those of another app.
![sync](ccfsSync.png)

In memory this happens as well:
![sync](ccfsOrder.png)


Overall structure:
- per-app streams
- per-stream *transactions* that buffer meta-ops while maintaining order
- *hybrid-granularity*
![hybrid](ccfsHybrid.png)
- inter-stream interactions noted
- delta journaling
  - saves op vs data values
  - *appears* used only for internal data structures
       - must be an API for it
       - free inode count
       - free block count
       - *nlink* on directory inodes
- pointer-less data structures
  - pointers (or offsets) affected by other streams
      - orphan block list (linked list)
      - directories (offsets to next entry
- uses *selective data journaling*
    - journaling only overwritten file data
    - otherwise just metadata + block ptrs (for appends)
	- "modern workloads are mostly composed of appends"


Questions:
- "A's stream will overwrite B's stream"
- both byte streams AND blocks, and only one journal (multiple streams)
- test write ordering?
- how does journal help crash recovery if no data?
- "sequential consistency" (greg)  I'd argue just a partial ordering.
- transaction data structure?
//=====================================================================

# Eventually consistent
**CAP**
- consistent
- available
- partition tolerant
**Choose any two**

Consistency models
- Strong  (really linearizability)
- Weak   (a window?)
- Eventual
    - *convergence*

### Client-side
- causal
    - think *happens-before*
- read-your-writes
    - should never see something earlier than something I wrote
- monotonic read consistency
    - if I see version v, should never see anything earlier
- monotonic read consistency
    - if I see version v, should never see anything earlier
- monotonic write consistency
    - all writes by single process ordered
- session consistency
    - general approach requiring personal view never to go backwards	

Previous 5 basically came from the [Bayou](http://triffid.cs.umd.edu/dss/blog.rb?tag=bayou) project (next week).


### Server-side
Quorums: *(R + W) > N*


### Questions:
- partition means slow network?
- how long until convergence?   [October 10th](http://triffid.cs.umd.edu/dss/blog.rb)
