# Elephant

### Goals:
- undo vs long-term history

### Files:
- read-only
- derived
- cached
- temporary
- user-modified  <-- need versioning

### Policies:
- keep one  (browser cache, core, /tmp)
- keep all  
- keep safe   (just undo)
- keep landmarks <--

### Metadata:
- imap
- ptr into
    - inode log (versioned per-file) or 
    - multiple non-versioned file inodes
- temperature
- policies
![imap](imap2.png)

### Directories
- ordinary file
    - versioning inside file, not outside
- basically a log of changes:
    - create
    - mutate
	- delete
- history partition
    - move old deletes into a second inode so as to not slow current operations	

![dirs](dirs.png)

### Useful:

    cd foo/@12-nov-1999:11:30
    tls      'ls @v'
    tgrep


### Application policies:
- user-level process called when the cleaner comes across high-temp file

### Downsides:
- less locality in inodes, data blocks
- pressure on buffer cache



## Comments

- lbfs chunking
- video editing "too large"
  - functional edits?
- disconnected operation and name collision (bilbro)
- "achieves same thing as log-structured"
- "doesn't give enough credit to users", but
  - "allows users to create bad policies"
- use diffs between versions of a chain to a land-mark
- google docs / dropbox paper
- "file mods rarely update every block"  ..... eh
- poor evaluation and imcomplete description of experiment setup
  - is cleaner running?  how often?
  - what keep-safe window

(epaxos duplication problems)
