
# Immutability Changes Everything

![im](immut1.png)

Trends:
- increasing storage
- increasing distribution
- increasing ambiguity
- LSF, COW, LSM

## Append-only computing
- logs are **the truth**
- single-master changes are applied sequentially via single-master or concensus

## Data on the:
- inside
  - mutable relational data
- outside: think artifacts, reports, summaries
  - immutable
  - identity
  - (possibly) versioned

## Immutable Is Not Always Immutable
- optimizing for read access: indexes, de-normalization
- farming out portions of work, with re-try.
- bit meanings change
- normalization is there to eliminate update anomalies
  - table decomposition takes a single large table and makes multiple small tables
  - updating mult tables causes *update anomolies*
  - anomolies addressed by *normalization*, which makes the tables a bit less efficient
  - if immutable, no anomolies, so....
  - versioned data changes, but versions do not

## Bottom line
1. Immutability enables unambiguous identity
1. Immutability enables massive replication/caching/parallelism
1. Immutability eliminates locking
1. Immutability enables re-computation
- from immutable
- of immutable




