# SUNDR

**fetch-modify-consistency**
- if server honest: fetch reflects all modifies before it
- if not: **fork consistency**: clients can detect any integrity or consistency failures as long as they see each other’s modifications


Enables:
- outsourcing storage management
- recovering by using client caches

Operations:
- *fetch*: retrieve file contents, or validated cache
- *modify*: write to the file system

Bootstrap:
- public-key superuser
- superuser manages user/key list
- server administration *does not need keys*

## Strawman

- no concurrent operations
- global untrusted lock
- perform op by:
  - acquire lock
  - do op
  - release lock
- each op includes user sig for new op
  - and all preceding ops

To fetch a file:
- client acquires lock
- downloads entire history of file system
- validates
- reconstructs local FS from history
- does op

Worst that can happen is a fork:
![](sundrFork.png)

*Strongest consistency without online trusted parties*

## SUNDR

- all files *writable* by a user are aggregated into an **i-handle**.
- *i-handles* are compared using version vectors

![](sundrIhandle.png)

## Version Structure Lists

VSLs...
![](sundrIhandleVersion.png)

Attack...
![](sundrIhandleAttack.png)

![](sundrConcurrentUpdates.png)



## Concurrent SUNDR

- pre-declare fetch or modify
- **update certificates**

## Notes
- *timestamp boxes*

-----------------


# Sporc

(collab edit, key store)

Operational Transforms + fork consistency

Goals
- broad class of apps ??
- quick
- tolerate varying connectivity
- privacy from server and unauthorized users
- detect misbehaving server
- recover from misbehaving server

## Operational Transformations

Example:

        ABCDE
        alice says del(2)    -->   abde
            concurrent
        gob says del(4)      -->   abcd

`del(2)` after a `del(4)` fine.
`del(4)` after a `del(2)` results in data overrun.

*T(op1, op2)* --> op1', op2'
- if originally applied op1, then apply op2'
- if originally applied op2, then apply op1'

![](sporcDel.png)


- operations in pending q are applied optimistically
- new operations from server that should have been applied before local
  optimistic ops must be *transformed*

## Fork Consistency
 
![](sporcArch.png)

## Notes:
- app supply transform function
- all ops invertible
- barriers for key management, membership changes
- mutually trusting clients


## Detection
- two clients discover misbehaving server by comparing histories

## Recovery
- they each *roll back* until the fork
- decide on a new server
- upload to fork to the server
- submit forked ops independently to the server
- ops must be invertible.

## Crypto
- per-document public keys, per-user public keys
- symmetric key for data
- all users w/ permission for file have file's private key
- barriers for changing keys, users

## Thoughts:
- not just detect: repair
- when is an op committed?

