# Knockoff
- operation shipping
- *eidetic versioning*: any past state in the file system or in application memory
- stores non-deterministic log for replay

## Nondeterministic log:
- system call results
- thread scheduling
- external data read (references other file in FS)

## Stores by value when:
- programs to produce are not in cloud
- computation costlier than comm

## Versioning:
- none
- on close
- on write
- eidetic (system call)

Uses per-application histories to catch long-running apps that might benefit from ops (multiple versions?)


Store by op if *cold*.

## Issues
- Reproducing past file may need input data from other logs
  - version vector shows depend graph between files
  - *materialization delay* is delay to reproduce inputs and the file
- Costs
  - 7%-8% recording
  - up to a minute to re-constitute
Doesn't mention word *interactive*.


# Comments
- "When a hashing function becomes obsolete, any file system has to adapt" - patrick
- video editing - patrick
- could use as a way of duplicating an environment - andrew
- materialization delay
- assumes computation cheaper than network communication
- "All client caches are managed via LRU eviction, but LRU could be sequential flooding if # frame < loop size. If there are many pages in buffer/cache, LRU's implementation cost is extremely high!"
- "Records are not always deterministic. Some race-free, multi-threading programs may lead to non-determinstic situation happen. For large files, switching to fallback option - by value may not be a good idea!"
- amount of access Knockoff would require to the user-level processes slightly creepy
- costs very highly depnding on cloud/local/ISP decisions

<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;<p>&nbsp;

# What I like / Complications
- cost function
- regenerate these past versions through additional recursive replays of the applications that produced the data.
- it may be the case that sending and replaying the log collected so far would help reduce the cost of future file modifications that have yet to be seen
 

