# SALT

"offering atomicity and isolation at the same granularity is the very reason why ACID
transactions are ill-equipped .....(performance vs programmability)"

**Pareto Principle:** 80% of effects from 20% of causes

-splitting ACID transactions up very good for concurrency
 - bad for isolation
- key issue is to provide isolation at a finer granularity, same atomicity
  - nested transactions give subtrans' atomicity, isolate entire thing


 *Allow isolation to be specified at smaller granularity than atomicity*

## Background

ANSI iso levels:
- read-uncommitted
- read-committed (assumed goal for paper)
- repeatable read
- serializable

Issues:
- dirty writes: overwrite uncomitted
- dirty reads: read from uncommitted
- non-repeatable reads
- phantom

## Big Things
- BASE transactions
- salt isolation
- clever names

## BASE transactions
  - **alkaline** subtransactions
    - no other transactions can see state of *uncommitted alkaline subtrans*
    - **committed** alk subtrans state viewable by other BASE or alkaline transactions
    - *not visible* to ACID until entire BASE commit.
	- intended for *partition-local* ops
  - **salt isolation** allows control of internal states visibility (among other BASE transactions)
  - each alkaline sub has associated *exception*
  - *BASE transactions look like ACID transactions to other ACID transactions*
  - **accepted** once any alkaline trans commits,
    - accepted implies commit of entire BASE
    - i.e. all operations successfully executed *or bypassed because of some exception*
  - aborted only if they encounter an error before the transaction is accepted (unlike ACID)

## Salt Isolation

*"If two operations in different transactions conflict, then the temporal dependency
    that exists between the earlier and the later of these operations  must extend to the
    entire transaction"* (allows SALT to work w/ different isolation levels)

*Isolation:* Let Q be the set of operation types {*read*, *range-read*, *write*} and let L and S
be subsets of Q . Further, let *o<sub>1</sub>* in *txn<sub>1</sub>* and *o<sub>2</sub>* in *txn<sub>2</sub>*, be two operations, respectively
of type *T<sub>1</sub>* ∈ L and *T<sub>2</sub>* ∈ S , that access the same object in a conflicting
(i.e. non read-read) manner. **If *o<sub>1</sub>* completes before *o<sub>2</sub>* starts, then *txn<sub>1</sub>* must decide
before *o<sub>2</sub>* starts.**

<img src=saltSets.png width=500>

The Isolation property holds as long as (a) at least one of txn<sub>1</sub> and
txn<sub>2</sub> is an ACID transaction or (b) both txn<sub>1</sub> and txn<sub>2</sub> are alkaline
subtransactions.  

So:
- ACID transactions isolated from all other
- Alkaline subtrans isolated from ACID and other alkaline
- BASE expose states at alkaline boundaries to other BASE


- Design
  - locks (because high contention)
    - type
      - ACID - conflict with alkaline and saline
      - alkaline - conflict w/ ACID and other alkaline
      - saline: conflict with ACID locks (except for read/read) only
    - lock duration
      - *long term* (life of (sub-)trans, 2PL) 
      - *short-term* (just the op)
    - acquire only an alkaline lock at operation start
      - “downgrade” it to saline at end of subtransaction, hold until after the end of the BASE transaction. 
  - no multi-version concurrency

![sets](saltConcurrent.png)

## Indirect Dirty Reads
<p>

![fig4](saltFig4.png)
<p>
Fixed by:

- **Read-after-write across transactions** A BASE transaction *B<sub>r</sub>* that reads a value x, which has been written by another *BASE<sub>w</sub>* transaction, cannot release its saline lock on x until *B<sub>w</sub>* has released its own saline lock on x. 

- **Write-after-read within a transaction** An operation *O<sub>w</sub>* that writes a value x cannot
  release its saline lock on x until all previous read operations within the **same** BASE
  transaction have released their saline locks on their respective objects.

These two ensure uncommitted writes keep locks until all prior read locks also released.

<p>

## Forward Logging
- after BASE knows it will commit (because a subsaline committed), log entire BASE
- prevents cascades that would have occurred because of saline visibility

### Banking, again

![fig1](saltAcidApp.png)
![banking](saltBanking.png)

## Performance

![saltPerf1](saltPerf1.png)

![saltPerf2](saltPerf2.png)


## Comments




//=====================================================================

# Correctness Anomalies Under Serializable Isolation

Background: serializability guarantees an execute (a schedule)
equivalent to a serial schedule, but this serial schedule does not
have to be the ordering that actually occurred in real time (wall
clock time).

Background: *one-copy serilizability* (1SR):
```
...either ... will be ordered first in the equivalent serial order. Whichever transaction is second --- when it reads the balance --- it must read the value written by the first transaction
```

### The Immortal write
<img src=immortalWrite.png width=500>

### The Stale Read
<img src=staleRead.png width=500>

### The Stale Read
<img src=staleRead.png width=500>

### The Causal Reverse
<img src=causalReverse.png width=500>

*Strict serializability* prevents the all of these.
