# Eris

## Principles

- Separate ordering from execution
  - can do if ordering in the network
  - if transactions forbid cross-shard dependencies
- Rapid ordering from being in the network
- Unify replication and transaction coordination
  - again, can do if we are the ghost-in-the-network

![](eris1.png)
&nbsp;<p>
&nbsp;<p>
&nbsp;<p>
&nbsp;<p>
&nbsp;<p>
&nbsp;<p>
&nbsp;<p>
&nbsp;<p>
![](eris2.png)
&nbsp;<p>
&nbsp;<p>
&nbsp;<p>
&nbsp;<p>
&nbsp;<p>
&nbsp;<p>
&nbsp;<p>
&nbsp;<p>
![](eris3.png)
&nbsp;<p>
&nbsp;<p>
&nbsp;<p>
&nbsp;<p>
&nbsp;<p>
&nbsp;<p>
&nbsp;<p>
&nbsp;<p>

### In-network concurrency control
- globally consistent ordering across multiple shards
- not reliable
- recipients can detect dropped messages

### *Multi-sequenced* groupcast
- hdrs specifies a **set** of multicast groups
- msgs sequenced atomically across all
- sequencer keeps a counter for each group


## Implementation
- Routing using OpenFlow
- sequencer implementations
  - programmable swiches in P4
  - middlebox w/ network processors

## Transactions
**Independent transactions:**
- one-shot (stored procedures), send to multiple shards
- shards do not communicate with each other, i.e. no cross-shard dependencies
- each shard must independently come to the **same** commit/abort decision
- works for TPC-C!

**Fully general transactions:**
- client reads and writes to multiple shards
- actions may be dependent on read results
- client eventually determines commit/abort

## Why independent transactions good?
- No communication across shards
- Executing them serially in **consistent order** at each shard guarantees **serializability**.
  - Multi-sequenced groupcast gives them this.

## How implement general transactions?
- if read/writesets known a priori
  - send *preliminary* transactions to perform reads and acquire locks
  - send *conclusory* transaction to **commit/abort**
- if not known
  - send *reconnaissance queries* (like Calvin)
  - then do the above, iterating if read/writesets change
