
# Semantic file system:
- virtual files populated with app-specific transducers
- "navigation" - populated w/ tags that further distinguish query results

Notion of "invisible" direcotries:
- not returned in readdirs
- can be directly addressed

### Transducers:
- NYT articles
- imports/exports of object files
- imports/exports of source files

### Concepts:
- field virtual directory
  - one entry ("value virtual directory") for each "possible" value 
  - entities could be *smaller* or *larger* than file
  - invisible dirs
    - used to pre-instantiate field virtual dirs w/o returning them to 'ls'
- value virtual directories
- *convergent query consistent*

![syntax](semanticSyntax.png)

### Implementation
- NFS server to implement
  - mount point
  - overlay system
- Indexing every two minutes
- Virtual directories triggered on
  - readdir
  - lookup

### Comments
- no/poor eval
- hard to remember which transducer produces what fields for which files
- gmail
- turn dirs into tags (see next paper)
- Automatic attribute extraction could perhaps be augmented with comp. ling.-esque expectation maximization.
- security hard (why?)

how is a conventional hier different than tags?

- mac "smart folders"


# Logic File System

"paths are formulas"
- boolean queries ('/' is conjunction, and commutes)

### Hier paradigm:
Good:
- navigation hints
- only relevant  (if hier breaks down big concepts into smaller)

Bad:
- only one path?
- hard to find
- rigid

### Boolean google paradigm:
![boolean file system](logicBoolean.png)
Good:
- very expressive
- easy to describe a doc with conjunctions
- disjunctions, negation

Bad:
- no hints (relevant keywords for navigation)


### Syntax:
- user creates high-level tags by making dirs off of root
- register/delete tags is create/remove dirs
- **'/' is conjunction**
- mv changes a file's tags: `mv p1/foo p2/foo`
- disjunction:
  - `cd (size:46|size:72|...)`
- negation:
  - `!foo`

![boolean file system](logicExamples.png)

### Navigation
- bare ls at root would list subdirs for all tags
- 'ls' lists 
  - "relevent" sub-dirs (those that distinguish)
  - all files that can not be further categorized
    - *files only listed in dir if no further keyword difference*


### Manual hierarchies
- creating tag 'a' inside 'b' implies subsetting ('a' more general)


### Comments
- say we create /a, and /a/b. What happens if we cd into /b/a, same
thing? What about the relationship between the two? 

- Are there two different types of directories, those created w/ mkdir, and those not?

- How to prevent things from moving around if we have transducers. Is
  this a problem?

- How about different versions, or different providers (/usr,
  /usr/bin, /opt)

### Broader questions

- Why at the file system level?
  - transparent functionality for all
  - user knows it

- security and *privacy*?

