# Sporc

(collab edit, key store)

Operational Transforms + fork consistency

Goals
- broad class of apps ??
- quick
- tolerate varying connectivity
- privacy from server and unauthorized users
- detect misbehaving server
- recover from misbehaving server

## Operational Transformations

Example:

        ABCDE
        alice says del(2)    -->   abde
            concurrent
        gob says del(4)      -->   abcd

`del(2)` after a `del(4)` fine.
`del(4)` after a `del(2)` results in data overrun.

*T(op1, op2)* --> op1', op2'
- if originally applied op1, then apply op2'
- if originally applied op2, then apply op1'

![](sporcDel.png)


- operations in pending q are applied optimistically
- new operations from server that should have been applied before local
  optimistic ops must be *transformed*

## Fork Consistency
 
![](sporcArch.png)

## Notes:
- app supply transform function
- all ops invertible
- barriers for key management, membership changes
- mutually trusting clients


## Detection
- two clients discover misbehaving server by comparing histories

## Recovery
- they each *roll back* until the fork
- decide on a new server
- upload to fork to the server
- submit forked ops independently to the server
- ops must be invertible.

## Crypto
- per-document public keys, per-user public keys
- symmetric key for data
- all users w/ permission for file have file's private key
- barriers for changing keys, users

## Thoughts:
- not just detect: repair
- when is an op committed?

