package Site::CertMonger;

use strict;
use warnings;

use base 'Resmon::Module';

use Resmon::ExtComm qw(run_command);

=pod

=head1 NAME

Site::CertMonger - Check if there is certificates in states other than status: MONITORING and stuck: no

=head1 SYNOPSIS

 Site:CertMonger {
     rofs: noop
 }

=head1 DESCRIPTION

This module greps output of 'ipa-getcert list' command

=head1 CONFIGURATION

=over

=item check_name

The check name is descriptive only in this check. It is not used for anything.

=back

=head1 METRICS

=over

=item check_name

The name of the current check. You wouldn't normally return this, but it is
here to show how to access the check name, and for testing purposes.

=item certs

Shows the certificates in states which are different from Monitoring or are stuck.

=back

=cut

sub handler {
    my $self = shift;
    my $config = $self->{config}; # All configuration is in here
    my $check_name = $self->{check_name}; # The check name is in here

    my $certs = '';
    open(my $listfh, "-|", "/usr/bin/ipa-getcert list") or die "can't read output of /usr/bin/ipa-getcert list:$!";
    my ($requestid,$stuck,$status) = ('','','');
    while (<$listfh>) {
       chomp;
       if (/^Request ID '(\d*)':/){
           if ($requestid && ($status || $stuck)) {
               $certs .= "$requestid; $status; $stuck\n";
               ($requestid,$status,$stuck)=('','','');
           }
           $requestid = $_;
       }elsif (/^\s*status: (?!MONITORING)/){
           $status = $_;
       }elsif (/^\s*stuck: (?!no)/){
           $stuck = $_;
       }
    }
    if ($requestid && ($status || $stuck)) {
        $certs .= "$requestid; $status; $stuck";
        ($requestid,$status,$stuck)=('','','');
    }

    return {
        "check_name" => [$self->{check_name}, "s"],
        "certs" => [$certs, "s"],
    };
};

1;

