package Site::DockerPs;

use strict;
use warnings;

use base 'Resmon::Module';

use Resmon::ExtComm qw(run_command);

=pod

=head1 NAME

Site::DockerPs - Check current docker VM status

=head1 SYNOPSIS

 Site::DockerPs {
    check_ps : docker_path => /usr/bin/docker
 }

=head1 DESCRIPTION

This module retrieves VM statistics.

=head1 CONFIGURATION

=over

=item check_name

Arbitrary name of the check.

=item docker_path

Optional path to the docker executable.

=back

=head1 METRICS

=over

=item active

=item inactive

=back

=cut

sub handler {
    my $self = shift;
    my $config = $self->{'config'};
    my $docker_path = $config->{'docker_path'} || 'docker';
    my $output_active = run_command("$docker_path ps --format '{{.Names}}:{{.Image}}'");
    my $output_inactive = run_command("$docker_path ps --filter 'status=exited' --format '{{.Names}}:{{.Image}}'");
    my %metrics = (
	"active" => $output_active,
	"inactive" => $output_inactive,
    );

    return \%metrics;
};

1;
