package Site::HWClock;

use strict;
use warnings;

use base 'Resmon::Module';

use Time::HiRes;
use Resmon::ExtComm qw(run_command);

=pod

=head1 NAME

Site::HWClock - check HWClock status

=head1 SYNOPSIS

 Site::HWClock {
    local : noop
 }

=head1 DESCRIPTION

This module retrieves HWClock value and compares to System clock statistics.

=head1 CONFIGURATION

=over

=item check_name

Arbitrary name of the check.

=head1 METRICS

=over

=item hwclock (time)

=item system (time)

=item diff (time)

=back

=cut

sub handler {
    my $self = shift;
    my $config = $self->{'config'};
    my $now = Time::HiRes::time();
    my $hwstring = `hwclock -r`;
    chomp $hwstring;
    $hwstring  =~ s/seconds *$//;
    $hwstring  =~ s/ *-?[0-9]*\.[0-9]* *$//;
    my $rtc = qx(date +%s.%N -d "$hwstring");
    chomp $rtc;

    return {
      "hwclock" => [$rtc, "%F"],
      "system"  => [$now, "%F"],
      "diff"    => [$now - $rtc, "%F"]
    };
};

1;

