package Site::IMAPlogin;

use strict;
use warnings;
use IO::Socket;
use Time::HiRes qw(tv_interval gettimeofday);

use base 'Resmon::Module';

use Resmon::ExtComm qw(run_command);

=pod

=head1 NAME

Site::IMAPlogin - check successful login and it's time

=head1 SYNOPSIS

 Site::IMAPlogin {
    <username>: passwd => <passwd>
 }

 Site::IMAPlogin {
    <username>: passwd => <passwd>, address => <IP address>
 }

=head1 DESCRIPTION

This module checks if login succeeds and what time it takes

=head1 CONFIGURATION

=over

=item check_name

The check name is username to use for logging into IMAP

=item passwd

Password to use for IMAP login

=back

=head1 METRICS

=over

=item time

The time elapsed for login and logout

=back

=cut

my $DEBUG=0;
sub handler {
  my $self = shift;
  my $config = $self->{config};
  my $user = $self->{check_name};
  my $pass = $config->{passwd};

  my $imap = IO::Socket::INET->new(
    Proto      => "tcp",
    PeerAddr   => "localhost",
    PeerPort   => "imap(143)",
  ) || die "can't connect to ssh service on localhost: $!";
  $imap->autoflush(1);
  my $b=[gettimeofday];
  while (<$imap>) {
    if (/ Dovecot ready./) {
      print $imap "0 login $user $pass\r\n";
    }
    if (/ Logged in./) {
      print $imap "1 logout\r\n";
    }
    if (/Logout completed./) {
    }
  };
  my $time = tv_interval($b);
  return { "time" => [$time, "n"] }
};

1;
=pod for testing use:
my %h = ( 
   config => { passwd => 'yourpassword' },
   check_name => 'yourusername',
);
my $hr=\%h;
handler( $hr );
=cut

