package Site::Ipmi;

use strict;
use warnings;

use base 'Resmon::Module';

use Resmon::ExtComm qw(run_command cache_command);

=pod

=head1 NAME

Site::Ipmi - Get bios information using IPMI

=head1 SYNOPSIS

 Site::Ipmi {
     power-restore-policy: cmd => chassis status, grep => Power Restore Policy
 }

=head1 DESCRIPTION

This module gets BIOS information using IPMI.
We currently check:
  - Power Restore Policy

=head1 CONFIGURATION

=over

=item state


=cut

sub handler {
    my $self = shift;
    my $config = $self->{config}; # All configuration is in here
    my $check_name = $self->{check_name}; # The check name is in here

    my $check_cmd = $config->{ipmitool} || "ipmitool -I open";
    my $check_arg = $config->{cmd};

    my $output = cache_command("$check_cmd $check_arg ", 30);
    my @lines = split(/\n/, $output);

    # Filter based on config
    @lines = grep(/^$config->{grep}\s+: (.+)$/, @lines);

    if ( (scalar @lines) < 1 ) {
        die "No result returned. Please adjust grep.";
    }
    if ( (scalar @lines) > 1 ) {
        die "More than one result returned. Please adjust grep.";
    }

    my ($line) = @lines;
    if( $line =~ /^$config->{grep}\s+: (.+)$/ ) {

        return {
           'state' => [$1, 's'],
        };

    } else {
        # We couldn't get the free space
        die "Unable to get IPMI information.\n";
    }

};

1;
