package Site::PSVar;

use strict;
use warnings;

use base 'Resmon::Module';

use Resmon::ExtComm qw(run_command cache_command);

=pod

=head1 NAME

Site::PSVar - get a value from the procesess table module

=head1 SYNOPSIS

 Site::PSVar {
     puppet : var => etimes, aggr => max
 }

=head1 DESCRIPTION

This module returns information on the state of the proceses on a running system.

=head1 CONFIGURATION

=over

=item check_name

The check name is the name of the process to pass to `ps -C` command 

=item var

The name of the attribute to get, like 'etimes' for elapsed time in second

=item aggr

The aggregate function if there are many processes with this name, now one of 2: 'max' or 'min'.

=back

=head1 title

=head1 value

=back

=cut

sub handler {
    my $self = shift;
    my $config = $self->{config}; # All configuration is in here
    my $check_name = $self->{check_name}; # The check name is in here
    my $var = $config->{var}; # what to look for
    my $aggr = $config->{aggr}; # what to look for


    my $ps_cmd = "ps -C $check_name -o $var";

    my $output = run_command($ps_cmd);
    my @values = split(/\n/, $output);
    my $title = shift @values;
    my @sorted = sort @values;
    my $value;
    if (scalar @values) {
       $value = ( $aggr eq 'max' ) ? pop @sorted : shift @sorted;
    }
    else {
       $value = 0
    }


    return {
        "title" => [$title, "s"],
        "value" => [$value, "i"],
    };
};

1;
