package Site::Packages;

use strict;
use warnings;

use base 'Resmon::Module';

use Resmon::ExtComm qw(run_command);

=pod

=head1 NAME

Site::Packages - Find updated packages

=head1 SYNOPSIS

 Site:Packages {
     check_pkgs : updatefile_path => /var/local/csdupdates
 }

=head1 DESCRIPTION

This module queries csdupdates to find possible package updates

=head1 CONFIGURATION

=over

=item check_name

The check name is descriptive only in this check. It is not used for anything.
Some checks use the check_name as part of the configuration, such as
free space checks that specify the filesystem to use.

=back

=head1 METRICS

=over

=item total

Shows all available package updates

=item security

Shows available sercurity updates

=back

=cut

sub handler {
    my $self = shift;
    my $config = $self->{'config'};
    my $pkgs_path = $config->{'update_filepath'} || '/var/local/csdupdates';
    my $output_total = run_command("grep -Po '(?<=^Total:)\\d*\$' $pkgs_path");
    my $output_security = run_command("grep -Po '(?<=^Security:)\\d*\$' $pkgs_path");
    chomp($output_total,$output_security);
    my %metrics = (
        "total" => [$output_total, "i"],
        "security" => [$output_security, "i"],
    );

    return \%metrics;

};

1;
