package Site::VMHostStatus;

use strict;
use warnings;
use DBI;

use base 'Resmon::Module';

=pod

=head1 NAME

Site::VMHostStatus - Monitor various stats of RHEV hosts

=head1 SYNOPSIS

 Site::VMHostStatus {
     hostname : host => hostname
 }

=head1 DESCRIPTION

This module collects the CPU, Memory and Network usage of VM hosts, both hypervisor and storage, 
and the number of active VMs for hypervisors. 

=head1 CONFIGURATION

=over

=item check_name

This should alway be "cpu".

=item host

This is the hostname (qualified or not) of the host to check.

=back

=head1 METRICS

=over

=item cpu

The average CPU utilization of the processor cores on the server

=back

=cut

sub handler {
    my $self = shift;
    my $config = $self->{config};

    my $hostname = $config->{host};
    if ( $hostname !~ /cs.umd.edu$/ ) {
        $hostname = "$hostname.cs.umd.edu";
    }

    my $dbh = DBI->connect( "DBI:Pg:dbname = engine;host = localhost; port=5432", 'engine', 'KugWS7NOOUl5SnpurWX5vg');
    if ( ! defined( $dbh ) ) {
       # Try one more time.
       sleep(5);
       $dbh = DBI->connect( "DBI:Pg:dbname = engine;host = localhost; port=5432", 'engine', 'KugWS7NOOUl5SnpurWX5vg');
    }

    # First get the CPU/mem/net stats.
    my $sth = $dbh->prepare( "SELECT usage_cpu_percent, usage_mem_percent, usage_network_percent FROM vds_statistics LEFT JOIN vds_static ON vds_statistics.vds_id = vds_static.vds_id WHERE vds_static.vds_name = ?" );
    my $qresult = $sth->execute( $hostname );

    my @dresult = $sth->fetchrow_array();
    my $cpu = $dresult[0] // 0;
    my $mem = $dresult[1] // 0;
    my $net = $dresult[2] // 0;

    # Now get the VM stats.
    $sth = $dbh->prepare( "SELECT status, vm_active, vm_migrating FROM vds_dynamic LEFT JOIN vds_static ON vds_dynamic.vds_id = vds_static.vds_id WHERE vds_static.vds_name = ?" );
    $qresult = $sth->execute( $hostname );

    @dresult = $sth->fetchrow_array();
    my $status = 3 - ($dresult[0] // 0);
    my $vma = $dresult[1] // 0;
    my $vmm = $dresult[2] // 0;

    # To avoid an error message we query the statement handle once more.
    @dresult = $sth->fetchrow_array();

    # Close the database connection.
    $dbh->disconnect();

    return { "cpu" => [$cpu, "i"],
             "mem" => [$mem, "i"],
             "net" => [$net, "i"],
             "vms" => [$vma, "i"],
             "vmm" => [$vmm, "i"],
             "status" => [$status, "i"]
    }
};

1;
