package Site::Vms;

use strict;
use warnings;

use base 'Resmon::Module';

use Resmon::ExtComm qw(run_command);

=pod

=head1 NAME

Core::Vms - Check current KVM VM status

=head1 SYNOPSIS

 Site::Vms {
    check_vms : virsh_path => /usr/bin/virsh
 }

=head1 DESCRIPTION

This module retrieves VM statistics.

=head1 CONFIGURATION

=over

=item check_name

Arbitrary name of the check.

=item virsh_path

Optional path to the virsh executable.

=back

=head1 METRICS

=over

=item active

=item inactive

=item autostart

=back

=cut

sub handler {
    my $self = shift;
    my $config = $self->{'config'};
    my $virsh_path = $config->{'virsh_path'} || 'virsh';
    my ($output_active,$output_autostart,$output_inactive)=('','','');
    $output_active = run_command("$virsh_path list --name");
    if ($output_active =~ m/please enter your authentication name/i){
        $output_active = run_command("ps --no-headers -C qemu-kvm -o args");
        $output_active =~ s|^/usr/libexec/qemu-kvm -name guest=([^,]*),debug-threads=on.*$|$1|gm;
    }
    else {
        $output_autostart = run_command("$virsh_path list --autostart --name");
        $output_inactive = run_command("$virsh_path list --name --inactive");
    }
    my %metrics = (
        "active" => $output_active,
        "inactive" => $output_inactive,
        "autostart" => $output_autostart,
    );

    return \%metrics;
};

1;
