package Site::ZFSSnapshot;

use strict;
use warnings;

use base 'Resmon::Module';

use Resmon::ExtComm qw(run_command);

=pod

=head1 NAME

Site::ZFSSNapshot - check existing of fresh zfs snapshot

=head1 SYNOPSIS

 Site::ZFSSNapshot {
     <zfsdataset>: noop
 }

=head1 DESCRIPTION

This module gives time since last snapshot created for the given zfs dataset 

=head1 CONFIGURATION

=over

=item check_name

The check name is the name of zfs dataset, which snapshots are checked

=back

=head1 METRICS

=over

=item <age>

time in seconds since last snapshot was taken

=item <line>

line of zfs list output, which script tried to parse

=back

=cut
my $DATE='/usr/gnu/bin/date';
if (! -x $DATE){$DATE='/usr/bin/date'};
sub handler {
    my $self = shift;
    my $config = $self->{config}; # All configuration is in here
    my $zfs = $self->{check_name};
    my ($when,$age) = (0,`date '+%s'`);
    chomp $age; $age -= $when;
    my $line = '';
    my ($count,$list);
    my $LIST = "/usr/sbin/zfs list -H -p -o creation -S creation -d 1 -t snapshot $zfs 2>&1";
    open ($list, "-|", $LIST)or die "can't run $LIST: $!";
=pod
1469459040
=cut
    if (($_ = <$list>) && ($_ =~ m/^(\d+)$/)){
      $when = $1;
      $age = `$DATE '+%s'` - $when; 
      $line = $_ if $_;
      while ( <$list> ) {};
      $count = $.;
    }
    return {
      "age"     => [$age,   "i"],
      "count"   => [$count, "i"],
      "line"    => [$line,  "s"]
    }
}

1;
