#! /usr/bin/env python

import json
import docker.client
import time
import os

d = docker.Client()
fd = open("manifest.json")
j = json.load(fd)

def extract_name(ctr):
    if 'Name' not in ctr: return None
    slashed_name = ctr['Name']
    return slashed_name.replace("/","")

def remove(name):
    if name is None: return
    try:
        d.kill(name)
    except:
        None
    try:
        d.remove_container(name)
    except:
        None
    os.system("sudo ip netns delete %s" % name)

for k in j:
    subnet = j[k]
    # First, kill the bridges.  We do this because otherwise any tcpdumps we leave
    # running will not terminate properly.
    if 'gateways' in subnet:
        gateways = subnet['gateways']
        for g in gateways:
            if 'bridge' in g:
                gname = g['name']
                gdev = g['bridge']
                os.system("sudo ip netns exec {} ip link delete {} type bridge".format(gname,gdev))
    if 'containers' in subnet:
        containers = subnet['containers']
        if 'gateways' in containers:
            gateways = containers['gateways']
            for g in gateways:
                remove(extract_name(g))
        if 'nodes' in containers:
            nodes = containers['nodes']
            for n in nodes:
                remove(extract_name(n))
