#! /usr/bin/env python

import subprocess
import yaml
from argparse import ArgumentParser

parser = ArgumentParser()
parser.add_argument('-f', '--file',
                    dest='file',
                    default='example.yml',
                    help='YML file containing the testbed configuration'
                    )

args = parser.parse_args()

with open(args.file) as cfile:
    conf = yaml.load(cfile)

ntwk = conf['network']
use_docker = ntwk.get('docker', False)

def stop_node(name,i):
    ctr_name = '{name}{i}'.format(name=name,i=i)
    if use_docker:
        command = ['docker', 'kill', ctr_name ]
        retval = subprocess.call(command)
        command = ['docker', 'rm', ctr_name ]
        retval = subprocess.call(command)
        command = ['sudo', 'rm', '/var/run/netns/'+ctr_name]
        retval = subprocess.call(command)
    else:
        command = ['sudo', 'ip', 'netns', 'delete', ctr_name]
        retval = subprocess.call(command)

for i in range(ntwk['num_nodes']):
    stop_node(ntwk['name'],i)

